/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.client.lib;

import org.aiwolf.client.lib.Passage;
import org.aiwolf.client.lib.SentenceType;
import org.aiwolf.client.lib.State;
import org.aiwolf.client.lib.Utterance;
import org.aiwolf.client.lib.Verb;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Species;

public class TemplateTalkFactory {
    public static Utterance estimate(Agent targetAgent, Role role) {
        return new Utterance(TemplateTalkFactory.getSCsentence(targetAgent, State.fromRole(role)));
    }

    public static Utterance comingout(Agent subjectAgent, Role role) {
        Verb verb = Verb.comingout;
        return new Utterance(TemplateTalkFactory.getSVCsentence(subjectAgent, verb, State.fromRole(role)));
    }

    public static Utterance inspected(Agent subjectAgent, Species species) {
        Verb verb = Verb.inspected;
        State o = State.fromSpecies(species);
        return new Utterance(TemplateTalkFactory.getSVCsentence(subjectAgent, verb, o));
    }

    public static Utterance medium_telled(Agent subjectAgent, Species species) {
        Verb verb = Verb.medium_telled;
        State o = State.fromSpecies(species);
        return new Utterance(TemplateTalkFactory.getSVCsentence(subjectAgent, verb, o));
    }

    public static Utterance guarded(Agent subjectAgent) {
        Verb verb = Verb.guarded;
        return new Utterance(TemplateTalkFactory.getSVsentence(subjectAgent, verb));
    }

    public static Utterance skip() {
        return new Utterance("SKIP");
    }

    public static Utterance over() {
        return new Utterance("Over");
    }

    private static String toString(SentenceType sentenceType, Passage passage) {
        String text = "";
        text = String.valueOf(text) + (Object)((Object)sentenceType.getUv()) + " " + sentenceType.getRate() + "% " + " ( " + TemplateTalkFactory.toString(passage) + " )";
        return text;
    }

    private static String toString(Passage passage) {
        return null;
    }

    private static String getSCsentence(Agent agent, State complement) {
        return String.valueOf(String.valueOf(agent.getAgentIdx())) + " " + complement.name();
    }

    private static String getSVsentence(Agent agent, Verb v) {
        return String.valueOf(String.valueOf(agent.getAgentIdx())) + " " + v.name();
    }

    private static String getSVCsentence(Agent agent, Verb v, State complement) {
        return String.valueOf(String.valueOf(agent.getAgentIdx())) + " " + v.name() + " " + complement.name();
    }
}

