/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.client.lib;

import org.aiwolf.client.lib.EnumType;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Species;

public enum State {
    bodyguard(EnumType.ROLE),
    freemason(EnumType.ROLE),
    medium(EnumType.ROLE),
    possessed(EnumType.ROLE),
    seer(EnumType.ROLE),
    villager(EnumType.ROLE),
    werewolf(EnumType.ROLE),
    villagerSide(EnumType.TEAM),
    werewolfSide(EnumType.TEAM),
    HUMAN(EnumType.SPECIES),
    GIFTED(EnumType.GIFTED);

    private EnumType enumType;

    private State(EnumType input) {
        this.enumType = input;
    }

    public EnumType getEnumType() {
        return this.enumType;
    }

    public static State fromRole(Role role) {
        switch (role) {
            case bodyguard: {
                return bodyguard;
            }
            case freemason: {
                return freemason;
            }
            case medium: {
                return medium;
            }
            case possessed: {
                return possessed;
            }
            case seer: {
                return seer;
            }
            case villager: {
                return villager;
            }
            case werewolf: {
                return werewolf;
            }
        }
        return null;
    }

    public Role toRole() {
        switch (this) {
            case bodyguard: {
                return Role.bodyguard;
            }
            case freemason: {
                return Role.freemason;
            }
            case medium: {
                return Role.medium;
            }
            case possessed: {
                return Role.possessed;
            }
            case seer: {
                return Role.seer;
            }
            case villager: {
                return Role.villager;
            }
            case werewolf: {
                return Role.werewolf;
            }
        }
        return null;
    }

    public static State fromSpecies(Species species) {
        switch (species) {
            case Human: {
                return HUMAN;
            }
            case Werewolf: {
                return werewolf;
            }
        }
        return null;
    }

    public Species toSpecies() {
        switch (this) {
            case HUMAN: {
                return Species.Human;
            }
            case werewolf: {
                return Species.Werewolf;
            }
        }
        return null;
    }

    public static State fromString(String input) {
        State[] stateArray = State.values();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            State noun = stateArray[n2];
            if (noun.name().equals(input)) {
                return noun;
            }
            ++n2;
        }
        return null;
    }
}

