/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.client.lib;

import java.util.ArrayList;
import org.aiwolf.client.lib.Conjection;
import org.aiwolf.client.lib.LogicalStracture;
import org.aiwolf.client.lib.Utterance;

public class Protocol {
    private String text;
    private ArrayList<Utterance> utterances = new ArrayList();
    private Conjection c = null;

    public Protocol(String input) {
        this.text = input;
        if (!this.text.startsWith("(")) {
            this.utterances.add(new Utterance(this.text));
        } else {
            LogicalStracture split = LogicalStracture.splitStracture(this.text);
            this.c = split.getC();
            ArrayList<String> splitString = split.getElement();
            for (String s : splitString) {
                this.utterances.add(new Utterance(s));
            }
        }
    }

    public Protocol(ArrayList<Utterance> inputU) {
        if (inputU.size() == 1) {
            Utterance u = inputU.get(0);
            this.text = u.getText();
            this.utterances.add(u);
            return;
        }
        String conjectionString = "and ";
        this.utterances = inputU;
        ArrayList<String> textSplit = new ArrayList<String>();
        for (Utterance u : this.utterances) {
            textSplit.add("( " + u.getText() + " ) ");
            textSplit.add(conjectionString);
        }
        textSplit.remove(textSplit.size() - 1);
        this.text = LogicalStracture.bondStrings(textSplit, "");
    }

    public Protocol(Utterance inputU) {
        this.text = inputU.getText();
        this.utterances.add(inputU);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ArrayList<Utterance> getUtterances() {
        return this.utterances;
    }

    public void setUtterances(ArrayList<Utterance> utterances) {
        this.utterances = utterances;
    }

    public Conjection getC() {
        return this.c;
    }

    public void setC(Conjection c) {
        this.c = c;
    }
}

