/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.client.lib;

import java.util.List;
import org.aiwolf.client.lib.Category;
import org.aiwolf.client.lib.State;
import org.aiwolf.client.lib.Verb;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Species;

public class Passage {
    String text;
    String[] split;
    Agent subject;
    Category category;
    Verb verb;
    State object = null;
    State state = null;
    State species = null;

    public Passage(String input) {
        this.text = input;
        this.split = input.split("\\s+");
        if (this.split[0].equals("SKIP")) {
            this.category = Category.SKIP;
        } else if (this.split[0].equals("Over")) {
            this.category = Category.OVER;
        } else {
            this.verb = Verb.fromString(this.split[1]);
            this.category = this.verb.getCategory();
            switch (this.category) {
                case COMINGOUT: {
                    this.object = State.fromString(this.split[2]);
                    break;
                }
                case ESTIMATE: {
                    this.state = State.fromString(this.split[1]);
                    break;
                }
                case RESULT: {
                    if (this.verb == Verb.guarded) break;
                    this.species = State.fromString(this.split[2]);
                }
            }
        }
    }

    public Agent getSubject(List<Agent> agentList) {
        if (this.category == Category.SKIP) {
            return null;
        }
        int idx = Integer.parseInt(this.split[0]);
        for (Agent agent : agentList) {
            if (agent.getAgentIdx() != idx) continue;
            return agent;
        }
        return null;
    }

    public Category getCategory() {
        return this.category;
    }

    public Verb getVerb() {
        return this.verb;
    }

    public Role getObject() {
        if (this.category == Category.COMINGOUT) {
            return this.object.toRole();
        }
        return null;
    }

    public Role getState() {
        if (this.category == Category.ESTIMATE) {
            return this.state.toRole();
        }
        return null;
    }

    public Verb getAction() {
        if (this.category == Category.RESULT) {
            return this.verb;
        }
        return null;
    }

    public Species getAttribution() {
        if (this.category == Category.RESULT) {
            return this.species.toSpecies();
        }
        return null;
    }
}

