/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.client.base.smpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.aiwolf.client.base.player.AbstractSeerPlayer;
import org.aiwolf.client.base.smpl.AdvanceGameInfo;
import org.aiwolf.client.lib.Passage;
import org.aiwolf.client.lib.Protocol;
import org.aiwolf.client.lib.TemplateTalkFactory;
import org.aiwolf.client.lib.Utterance;
import org.aiwolf.client.lib.Verb;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Judge;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Species;
import org.aiwolf.common.data.Talk;
import org.aiwolf.common.net.GameInfo;

public class SampleSeerPlayer
extends AbstractSeerPlayer {
    int comingoutDay;
    boolean isCameout;
    ArrayList<Judge> declaredJudgedAgentList = new ArrayList();
    boolean isSaidInspectResultToday;
    AdvanceGameInfo agi = new AdvanceGameInfo();
    Agent planningVoteAgent;
    Agent declaredPlanningVoteAgent;
    int readTalkListNum;

    @Override
    public void initialize() {
        super.initialize();
        this.comingoutDay = new Random().nextInt(3) + 1;
        this.isCameout = false;
    }

    @Override
    public void dayStart() {
        super.dayStart();
        this.declaredPlanningVoteAgent = null;
        this.planningVoteAgent = null;
        this.setPlanningVoteAgent();
        this.isSaidInspectResultToday = false;
        this.readTalkListNum = 0;
    }

    @Override
    public String talk() {
        ArrayList<Utterance> utterances = new ArrayList<Utterance>();
        if (this.declaredPlanningVoteAgent != this.planningVoteAgent) {
            Utterance u = TemplateTalkFactory.estimate(this.planningVoteAgent, Role.werewolf);
            utterances.add(u);
            this.declaredPlanningVoteAgent = this.planningVoteAgent;
        }
        if (!this.isCameout && this.getDay() >= this.comingoutDay) {
            Utterance u2 = TemplateTalkFactory.comingout(this.getMe(), this.getMyRole());
            utterances.add(u2);
            this.isCameout = true;
        }
        if (this.isCameout && !this.isSaidInspectResultToday) {
            for (Judge judge : this.getMyJudgeList()) {
                if (this.declaredJudgedAgentList.contains(judge)) continue;
                Utterance u_result = TemplateTalkFactory.inspected(judge.getTarget(), judge.getResult());
                utterances.add(u_result);
                this.declaredJudgedAgentList.add(judge);
            }
            this.isSaidInspectResultToday = true;
        }
        if (utterances.size() > 0) {
            Protocol p = new Protocol(utterances);
            return p.getText();
        }
        return TemplateTalkFactory.over().getText();
    }

    @Override
    public Agent vote() {
        return this.planningVoteAgent;
    }

    @Override
    public Agent divine() {
        ArrayList<Agent> nonInspectedAgentList = new ArrayList<Agent>();
        for (Agent agent : this.getLatestDayGameInfo().getAliveAgentList()) {
            if (this.isJudgedAgent(agent)) continue;
            nonInspectedAgentList.add(agent);
        }
        if (nonInspectedAgentList.size() == 0) {
            return this.getMe();
        }
        return (Agent)nonInspectedAgentList.get(new Random().nextInt(nonInspectedAgentList.size()));
    }

    @Override
    public void finish() {
    }

    @Override
    public void update(GameInfo gameInfo) {
        super.update(gameInfo);
        List talkList = gameInfo.getTalkList();
        int i = this.readTalkListNum;
        while (i < talkList.size()) {
            Talk talk = (Talk)talkList.get(i);
            Protocol protocol = new Protocol(talk.getContent());
            for (Utterance u : protocol.getUtterances()) {
                Passage p = u.getPassage();
                if (p.getVerb() != Verb.comingout) continue;
                this.agi.getComingoutMap().put(talk.getAgent(), p.getObject());
                if (p.getObject() != this.getMyRole() || talk.getAgent().equals((Object)this.getMe())) continue;
                this.setPlanningVoteAgent();
            }
            ++i;
        }
        this.readTalkListNum = talkList.size();
    }

    public void setPlanningVoteAgent() {
        Random rand;
        List aliveAgentList = this.getLatestDayGameInfo().getAliveAgentList();
        aliveAgentList.remove(this.getMe());
        ArrayList<Agent> voteAgentCandidate = new ArrayList<Agent>();
        for (Agent agent : aliveAgentList) {
            if (this.agi.getComingoutMap().containsKey(agent) && this.agi.getComingoutMap().get(agent) == this.getMyRole()) {
                voteAgentCandidate.add(agent);
                continue;
            }
            for (Judge judge : this.getMyJudgeList()) {
                if (!judge.getTarget().equals((Object)agent) || judge.getResult() != Species.Werewolf) continue;
                voteAgentCandidate.add(agent);
            }
        }
        if (voteAgentCandidate.contains(this.planningVoteAgent)) {
            return;
        }
        if (voteAgentCandidate.size() > 0) {
            rand = new Random();
            this.planningVoteAgent = (Agent)voteAgentCandidate.get(rand.nextInt(voteAgentCandidate.size()));
        } else {
            rand = new Random();
            this.planningVoteAgent = (Agent)aliveAgentList.get(rand.nextInt(aliveAgentList.size()));
        }
    }
}

