/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.client.base.smpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.aiwolf.client.base.player.AbstractPossessedPlayer;
import org.aiwolf.client.base.smpl.AdvanceGameInfo;
import org.aiwolf.client.lib.Passage;
import org.aiwolf.client.lib.Protocol;
import org.aiwolf.client.lib.TemplateTalkFactory;
import org.aiwolf.client.lib.Utterance;
import org.aiwolf.client.lib.Verb;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Judge;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Species;
import org.aiwolf.common.data.Talk;
import org.aiwolf.common.net.GameInfo;

public class SamplePossesedPlayer
extends AbstractPossessedPlayer {
    int comingoutDay;
    boolean isCameout;
    ArrayList<Judge> declaredFakeJudgedAgentList = new ArrayList();
    boolean isSaidFakeResultToday;
    AdvanceGameInfo agi = new AdvanceGameInfo();
    Agent planningVoteAgent;
    Agent declaredPlanningVoteAgent;
    int readTalkListNum;
    Role fakeRole;
    List<Judge> fakeJudgeList = new ArrayList<Judge>();

    @Override
    public void initialize() {
        super.initialize();
        List<Role> fakeRoleList = Arrays.asList(Role.seer, Role.medium, Role.villager);
        this.fakeRole = fakeRoleList.get(new Random().nextInt(fakeRoleList.size()));
        this.comingoutDay = new Random().nextInt(3) + 1;
        if (this.fakeRole == Role.villager) {
            this.comingoutDay = 1000;
        }
        this.isCameout = false;
    }

    @Override
    public void dayStart() {
        this.declaredPlanningVoteAgent = null;
        this.planningVoteAgent = null;
        this.setPlanningVoteAgent();
        if (this.getDay() != 1) {
            this.setFakeResult();
        }
        this.isSaidFakeResultToday = false;
        this.readTalkListNum = 0;
    }

    @Override
    public String talk() {
        ArrayList<Utterance> utterances = new ArrayList<Utterance>();
        if (this.declaredPlanningVoteAgent != this.planningVoteAgent) {
            Utterance u = TemplateTalkFactory.estimate(this.planningVoteAgent, Role.werewolf);
            utterances.add(u);
            this.declaredPlanningVoteAgent = this.planningVoteAgent;
        }
        if (!this.isCameout && this.getDay() >= this.comingoutDay && this.fakeRole != Role.villager) {
            Utterance u2 = TemplateTalkFactory.comingout(this.getMe(), this.fakeRole);
            utterances.add(u2);
            this.isCameout = true;
        }
        if (this.isCameout && !this.isSaidFakeResultToday) {
            for (Judge judge : this.getMyFakeJudgeList()) {
                if (this.declaredFakeJudgedAgentList.contains(judge)) continue;
                Utterance u_result = null;
                if (this.fakeRole == Role.seer) {
                    u_result = TemplateTalkFactory.inspected(judge.getTarget(), judge.getResult());
                } else if (this.fakeRole == Role.medium) {
                    u_result = TemplateTalkFactory.medium_telled(judge.getTarget(), judge.getResult());
                }
                utterances.add(u_result);
                this.declaredFakeJudgedAgentList.add(judge);
            }
            this.isSaidFakeResultToday = true;
        }
        if (utterances.size() > 0) {
            Protocol p = new Protocol(utterances);
            return p.getText();
        }
        return TemplateTalkFactory.over().getText();
    }

    @Override
    public Agent vote() {
        return this.planningVoteAgent;
    }

    @Override
    public void finish() {
    }

    public void setPlanningVoteAgent() {
        List aliveAgentList = this.getLatestDayGameInfo().getAliveAgentList();
        aliveAgentList.remove(this.getMe());
        if (this.fakeRole == Role.villager) {
            if (aliveAgentList.contains(this.planningVoteAgent)) {
                return;
            }
            Random rand = new Random();
            this.planningVoteAgent = (Agent)aliveAgentList.get(rand.nextInt(aliveAgentList.size()));
        }
        ArrayList<Agent> fakeHumanList = new ArrayList<Agent>();
        ArrayList<Agent> voteAgentCandidate = new ArrayList<Agent>();
        for (Agent a : aliveAgentList) {
            if (!this.agi.getComingoutMap().containsKey(a) || this.agi.getComingoutMap().get(a) != this.fakeRole) continue;
            voteAgentCandidate.add(a);
        }
        for (Judge judge : this.getMyFakeJudgeList()) {
            if (judge.getResult() == Species.Human) {
                fakeHumanList.add(judge.getTarget());
                continue;
            }
            voteAgentCandidate.add(judge.getTarget());
        }
        if (voteAgentCandidate.contains(this.planningVoteAgent)) {
            return;
        }
        if (voteAgentCandidate.size() > 0) {
            Random rand = new Random();
            this.planningVoteAgent = (Agent)voteAgentCandidate.get(rand.nextInt(voteAgentCandidate.size()));
        } else {
            Random rand;
            List aliveAgentExceptHumanList = this.getLatestDayGameInfo().getAliveAgentList();
            aliveAgentExceptHumanList.removeAll(fakeHumanList);
            if (aliveAgentExceptHumanList.size() > 0) {
                rand = new Random();
                this.planningVoteAgent = (Agent)aliveAgentExceptHumanList.get(rand.nextInt(aliveAgentExceptHumanList.size()));
            } else {
                rand = new Random();
                this.planningVoteAgent = (Agent)aliveAgentList.get(rand.nextInt(aliveAgentList.size()));
            }
        }
    }

    @Override
    public void update(GameInfo gameInfo) {
        super.update(gameInfo);
        List talkList = gameInfo.getTalkList();
        int i = this.readTalkListNum;
        while (i < talkList.size()) {
            Talk talk = (Talk)talkList.get(i);
            Protocol protocol = new Protocol(talk.getContent());
            for (Utterance u : protocol.getUtterances()) {
                Passage p = u.getPassage();
                if (p.getVerb() != Verb.comingout) continue;
                this.agi.getComingoutMap().put(talk.getAgent(), p.getObject());
                if (p.getObject() != this.fakeRole || talk.getAgent().equals((Object)this.getMe())) continue;
                this.setPlanningVoteAgent();
            }
            ++i;
        }
        this.readTalkListNum = talkList.size();
    }

    public void setFakeResult() {
        Agent fakeGiftTarget;
        Random rand;
        if (this.fakeRole == Role.villager) {
            return;
        }
        ArrayList<Agent> fakeGiftTargetCandidateList = new ArrayList<Agent>();
        List aliveAgentList = this.getLatestDayGameInfo().getAliveAgentList();
        aliveAgentList.remove(this.getMe());
        for (Agent agent : aliveAgentList) {
            if (this.isJudgedAgent(agent) || this.fakeRole == this.agi.getComingoutMap().get(agent)) continue;
            fakeGiftTargetCandidateList.add(agent);
        }
        if (fakeGiftTargetCandidateList.size() > 0) {
            rand = new Random();
            fakeGiftTarget = (Agent)fakeGiftTargetCandidateList.get(rand.nextInt(fakeGiftTargetCandidateList.size()));
        } else {
            aliveAgentList.removeAll(fakeGiftTargetCandidateList);
            rand = new Random();
            fakeGiftTarget = (Agent)aliveAgentList.get(rand.nextInt(aliveAgentList.size()));
        }
        Species fakeResult = Math.random() < 0.3 ? Species.Werewolf : Species.Human;
        this.fakeJudgeList.add(new Judge(this.getDay(), this.getMe(), fakeGiftTarget, fakeResult));
    }

    public List<Judge> getMyFakeJudgeList() {
        return this.fakeJudgeList;
    }

    public boolean isJudgedAgent(Agent agent) {
        for (Judge judge : this.getMyFakeJudgeList()) {
            if (judge.getAgent() != agent) continue;
            return true;
        }
        return false;
    }
}

