/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.client.base.smpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.aiwolf.client.base.player.AbstractMediumPlayer;
import org.aiwolf.client.base.smpl.AdvanceGameInfo;
import org.aiwolf.client.lib.Passage;
import org.aiwolf.client.lib.Protocol;
import org.aiwolf.client.lib.TemplateTalkFactory;
import org.aiwolf.client.lib.Utterance;
import org.aiwolf.client.lib.Verb;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Judge;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Species;
import org.aiwolf.common.data.Talk;
import org.aiwolf.common.net.GameInfo;

public class SampleMediumPlayer
extends AbstractMediumPlayer {
    int comingoutDay;
    boolean isCameout;
    ArrayList<Judge> declaredJudgedAgentList = new ArrayList();
    boolean isSaidMediumTellResultToday;
    AdvanceGameInfo agi = new AdvanceGameInfo();
    Agent planningVoteAgent;
    Agent declaredPlanningVoteAgent;
    int readTalkListNum;

    @Override
    public void initialize() {
        super.initialize();
        this.comingoutDay = new Random().nextInt(3) + 1;
        this.isCameout = false;
    }

    @Override
    public void dayStart() {
        super.dayStart();
        this.declaredPlanningVoteAgent = null;
        this.planningVoteAgent = null;
        this.setPlanningVoteAgent();
        this.isSaidMediumTellResultToday = false;
        this.readTalkListNum = 0;
    }

    @Override
    public String talk() {
        ArrayList<Utterance> utterances = new ArrayList<Utterance>();
        if (this.declaredPlanningVoteAgent != this.planningVoteAgent) {
            Utterance u = TemplateTalkFactory.estimate(this.planningVoteAgent, Role.werewolf);
            utterances.add(u);
            this.declaredPlanningVoteAgent = this.planningVoteAgent;
        }
        if (!this.isCameout && this.getDay() >= this.comingoutDay) {
            Utterance u2 = TemplateTalkFactory.comingout(this.getMe(), this.getMyRole());
            utterances.add(u2);
            this.isCameout = true;
        }
        if (this.isCameout && !this.isSaidMediumTellResultToday) {
            for (Judge judge : this.getMyJudgeList()) {
                if (this.declaredJudgedAgentList.contains(judge)) continue;
                Utterance u_result = TemplateTalkFactory.medium_telled(judge.getTarget(), judge.getResult());
                utterances.add(u_result);
                this.declaredJudgedAgentList.add(judge);
            }
            this.isSaidMediumTellResultToday = true;
        }
        if (utterances.size() > 0) {
            Protocol p = new Protocol(utterances);
            return p.getText();
        }
        return TemplateTalkFactory.over().getText();
    }

    @Override
    public Agent vote() {
        return this.planningVoteAgent;
    }

    @Override
    public void finish() {
    }

    @Override
    public void update(GameInfo gameInfo) {
        super.update(gameInfo);
        List talkList = gameInfo.getTalkList();
        boolean existInspectResult = false;
        int i = this.readTalkListNum;
        while (i < talkList.size()) {
            Talk talk = (Talk)talkList.get(i);
            Protocol protocol = new Protocol(talk.getContent());
            for (Utterance u : protocol.getUtterances()) {
                Passage p = u.getPassage();
                if (p.getVerb() == Verb.comingout) {
                    this.agi.getComingoutMap().put(talk.getAgent(), p.getObject());
                    if (p.getObject() == this.getMyRole() && !talk.getAgent().equals((Object)this.getMe())) {
                        this.setPlanningVoteAgent();
                    }
                }
                if (p.getVerb() != Verb.inspected) continue;
                Agent seerAgent = talk.getAgent();
                Agent inspectedAgent = p.getSubject(gameInfo.getAgentList());
                Species inspectResult = p.getAttribution();
                Judge judge = new Judge(this.getDay(), seerAgent, inspectedAgent, inspectResult);
                this.agi.addInspectJudgeList(judge);
                existInspectResult = true;
            }
            ++i;
        }
        this.readTalkListNum = talkList.size();
        if (existInspectResult) {
            this.setPlanningVoteAgent();
        }
    }

    public void setPlanningVoteAgent() {
        ArrayList<Agent> voteAgentCandidate = new ArrayList<Agent>();
        List aliveAgentList = this.getLatestDayGameInfo().getAliveAgentList();
        aliveAgentList.remove(this.getMe());
        for (Agent agent : aliveAgentList) {
            if (!this.agi.getComingoutMap().containsKey(agent) || this.agi.getComingoutMap().get(agent) != Role.medium) continue;
            voteAgentCandidate.add(agent);
        }
        for (Judge myJudge : this.getMyJudgeList()) {
            for (Judge otherJudge : this.agi.getInspectJudgeList()) {
                if (!aliveAgentList.contains(otherJudge.getAgent()) || !myJudge.getTarget().equals((Object)otherJudge.getTarget()) || myJudge.getResult() == otherJudge.getResult()) continue;
                voteAgentCandidate.add(otherJudge.getAgent());
            }
        }
        if (this.planningVoteAgent != null && voteAgentCandidate.contains(this.planningVoteAgent)) {
            return;
        }
        if (voteAgentCandidate.size() > 0) {
            Random rand = new Random();
            this.planningVoteAgent = (Agent)voteAgentCandidate.get(rand.nextInt(voteAgentCandidate.size()));
        } else {
            Random rand;
            ArrayList<Agent> subVoteAgentCandidate = new ArrayList<Agent>();
            for (Judge judge : this.agi.getInspectJudgeList()) {
                if (!aliveAgentList.contains(judge.getTarget()) || judge.getResult() != Species.Werewolf) continue;
                subVoteAgentCandidate.add(judge.getTarget());
            }
            if (subVoteAgentCandidate.size() > 0) {
                rand = new Random();
                this.planningVoteAgent = (Agent)subVoteAgentCandidate.get(rand.nextInt(subVoteAgentCandidate.size()));
            } else {
                rand = new Random();
                this.planningVoteAgent = (Agent)aliveAgentList.get(rand.nextInt(aliveAgentList.size()));
            }
        }
    }
}

