/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.client.base.smpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.aiwolf.client.base.player.AbstractBodyGuardPlayer;
import org.aiwolf.client.base.smpl.AdvanceGameInfo;
import org.aiwolf.client.lib.Passage;
import org.aiwolf.client.lib.Protocol;
import org.aiwolf.client.lib.TemplateTalkFactory;
import org.aiwolf.client.lib.Utterance;
import org.aiwolf.client.lib.Verb;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Judge;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Species;
import org.aiwolf.common.data.Talk;
import org.aiwolf.common.net.GameInfo;

public class SampleBodyGuardPlayer
extends AbstractBodyGuardPlayer {
    AdvanceGameInfo agi = new AdvanceGameInfo();
    Agent planningVoteAgent;
    Agent declaredPlanningVoteAgent;
    int readTalkListNum;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void dayStart() {
        this.declaredPlanningVoteAgent = null;
        this.planningVoteAgent = null;
        this.setTodaysVotePlayer();
        this.readTalkListNum = 0;
    }

    @Override
    public String talk() {
        if (this.declaredPlanningVoteAgent != this.planningVoteAgent) {
            Utterance u = TemplateTalkFactory.estimate(this.planningVoteAgent, Role.werewolf);
            this.declaredPlanningVoteAgent = this.planningVoteAgent;
            return u.getText();
        }
        return TemplateTalkFactory.over().getText();
    }

    @Override
    public Agent vote() {
        return this.planningVoteAgent;
    }

    @Override
    public Agent guard() {
        Agent guardAgent;
        Random rand;
        ArrayList<Agent> guardAgentCandidate = new ArrayList<Agent>();
        List aliveAgentList = this.getLatestDayGameInfo().getAliveAgentList();
        aliveAgentList.remove(this.getMe());
        for (Agent agent : aliveAgentList) {
            List<Role> guardRoleList;
            if (!this.agi.getComingoutMap().containsKey(agent) || !(guardRoleList = Arrays.asList(Role.seer, Role.medium)).contains(this.agi.getComingoutMap().get(agent))) continue;
            guardAgentCandidate.add(agent);
        }
        if (guardAgentCandidate.size() > 0 && Math.random() < 0.8) {
            rand = new Random();
            guardAgent = (Agent)guardAgentCandidate.get(rand.nextInt(guardAgentCandidate.size()));
        } else {
            rand = new Random();
            guardAgent = (Agent)aliveAgentList.get(rand.nextInt(aliveAgentList.size()));
        }
        return guardAgent;
    }

    @Override
    public void finish() {
    }

    @Override
    public void update(GameInfo gameInfo) {
        super.update(gameInfo);
        List talkList = gameInfo.getTalkList();
        boolean existInspectResult = false;
        int i = this.readTalkListNum;
        while (i < talkList.size()) {
            Talk talk = (Talk)talkList.get(i);
            Protocol protocol = new Protocol(talk.getContent());
            for (Utterance u : protocol.getUtterances()) {
                Passage p = u.getPassage();
                if (p.getVerb() == Verb.comingout) {
                    this.agi.getComingoutMap().put(talk.getAgent(), p.getObject());
                    continue;
                }
                if (p.getVerb() != Verb.inspected) continue;
                Agent seerAgent = talk.getAgent();
                Agent inspectedAgent = p.getSubject(gameInfo.getAgentList());
                Species inspectResult = p.getAttribution();
                Judge judge = new Judge(this.getDay(), seerAgent, inspectedAgent, inspectResult);
                this.agi.addInspectJudgeList(judge);
                existInspectResult = true;
            }
            ++i;
        }
        this.readTalkListNum = talkList.size();
        if (existInspectResult) {
            this.setTodaysVotePlayer();
        }
    }

    public void setTodaysVotePlayer() {
        Random rand;
        if (this.planningVoteAgent != null) {
            for (Judge judge : this.agi.getInspectJudgeList()) {
                if (!judge.getTarget().equals((Object)this.planningVoteAgent)) continue;
                return;
            }
        }
        ArrayList<Agent> voteAgentCandidate = new ArrayList<Agent>();
        List aliveAgentList = this.getLatestDayGameInfo().getAliveAgentList();
        aliveAgentList.remove(this.getMe());
        for (Judge judge : this.agi.getInspectJudgeList()) {
            if (!aliveAgentList.contains(judge.getTarget()) || judge.getResult() != Species.Werewolf) continue;
            voteAgentCandidate.add(judge.getTarget());
        }
        if (voteAgentCandidate.size() > 0) {
            rand = new Random();
            this.planningVoteAgent = (Agent)voteAgentCandidate.get(rand.nextInt(voteAgentCandidate.size()));
        } else {
            rand = new Random();
            this.planningVoteAgent = (Agent)aliveAgentList.get(rand.nextInt(aliveAgentList.size()));
        }
    }
}

