/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.client.base.player;

import java.util.HashMap;
import java.util.Map;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Player;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.net.GameInfo;

public abstract class AbstractPlayer
implements Player {
    Map<Integer, GameInfo> gameInfoMap = new HashMap<Integer, GameInfo>();
    int day;
    Agent me;
    Role myRole;

    public String getName() {
        return String.valueOf(this.myRole.name()) + "Player:ID=" + this.me.getAgentIdx();
    }

    public void update(GameInfo gameInfo) {
        this.day = gameInfo.getDay();
        this.gameInfoMap.put(this.day, gameInfo);
    }

    public GameInfo getLatestDayGameInfo() {
        return this.gameInfoMap.get(this.day);
    }

    public GameInfo getGameInfo(int day) {
        try {
            return this.gameInfoMap.get(day);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<Integer, GameInfo> getGameInfoMap() {
        return this.gameInfoMap;
    }

    public Role getMyRole() {
        return this.myRole;
    }

    public Agent getMe() {
        return this.me;
    }

    public int getDay() {
        return this.day;
    }

    public void setAgent(Agent agent) {
        this.me = agent;
    }

    public void initialize() {
        this.myRole = this.gameInfoMap.get(this.getDay()).getRole();
        this.me = this.gameInfoMap.get(this.getDay()).getAgent();
    }

    public abstract void dayStart();

    public abstract String talk();

    public abstract String whisper();

    public abstract Agent vote();

    public abstract Agent attack();

    public abstract Agent divine();

    public abstract Agent guard();

    public abstract void finish();
}

