/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.server.net;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Request;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.net.DataConverter;
import org.aiwolf.common.net.Packet;
import org.aiwolf.common.util.BidiMap;
import org.aiwolf.server.GameData;
import org.aiwolf.server.LostClientException;
import org.aiwolf.server.net.GameServer;

public class TcpipServer
implements GameServer {
    int port;
    int limit;
    boolean isWaitForClient;
    BidiMap<Socket, Agent> socketAgentMap;
    GameData gameData;
    Logger serverLogger;

    public TcpipServer(int port, int limit) {
        this.port = port;
        this.limit = limit;
        this.socketAgentMap = new BidiMap();
        String loggerName = this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForConnection() throws IOException, SocketTimeoutException {
        for (Socket sock : this.socketAgentMap.keySet()) {
            if (sock == null || !sock.isConnected()) continue;
            sock.close();
        }
        this.socketAgentMap.clear();
        System.out.println("Waiting for connection...\n");
        ServerSocket svsock = new ServerSocket(this.port);
        int idx = 0;
        this.isWaitForClient = true;
        while (this.socketAgentMap.size() < this.limit && this.isWaitForClient) {
            Socket socket = svsock.accept();
            BidiMap<Socket, Agent> bidiMap = this.socketAgentMap;
            synchronized (bidiMap) {
                Agent agent = Agent.getAgent((int)idx++);
                this.socketAgentMap.put((Object)socket, (Object)agent);
                System.out.printf("Connect %s ( %d/%d )\n", agent, this.socketAgentMap.size(), this.limit);
            }
        }
        svsock.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Agent> getConnectedAgentList() {
        BidiMap<Socket, Agent> bidiMap = this.socketAgentMap;
        synchronized (bidiMap) {
            return new ArrayList<Agent>(this.socketAgentMap.values());
        }
    }

    protected void send(Agent agent, Request request) {
        try {
            String message;
            Packet packet;
            if (request != Request.Finish) {
                packet = new Packet(request, this.gameData.getGameInfoToSend(agent));
                message = DataConverter.getInstance().convert((Object)packet);
            } else {
                packet = new Packet(request, this.gameData.getFinalGameInfoToSend(agent));
                message = DataConverter.getInstance().convert((Object)packet);
            }
            Socket sock = (Socket)this.socketAgentMap.getKey((Object)agent);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(sock.getOutputStream()));
            bw.append(message);
            bw.append("\n");
            bw.flush();
        }
        catch (IOException e) {
            throw new LostClientException(e);
        }
    }

    protected Object request(Agent agent, Request request) {
        try {
            Socket sock = (Socket)this.socketAgentMap.getKey((Object)agent);
            BufferedReader br = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            this.send(agent, request);
            String line = br.readLine();
            if (request == Request.Talk || request == Request.Whisper || request == Request.Name || request == Request.Role) {
                return line;
            }
            return DataConverter.getInstance().toAgent((Object)line);
        }
        catch (IOException e) {
            throw new LostClientException("Lost connection with " + agent, e);
        }
    }

    @Override
    public void init(Agent agent) {
        this.send(agent, Request.Initialize);
    }

    @Override
    public String requestName(Agent agent) {
        return (String)this.request(agent, Request.Name);
    }

    @Override
    public Role requestRequestRole(Agent agent) {
        String roleString = (String)this.request(agent, Request.Role);
        try {
            return Role.valueOf((String)roleString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String requestTalk(Agent agent) {
        return (String)this.request(agent, Request.Talk);
    }

    @Override
    public String requestWhisper(Agent agent) {
        return (String)this.request(agent, Request.Whisper);
    }

    @Override
    public Agent requestVote(Agent agent) {
        return (Agent)this.request(agent, Request.Vote);
    }

    @Override
    public Agent requestDivineTarget(Agent agent) {
        return (Agent)this.request(agent, Request.Divine);
    }

    @Override
    public Agent requestGuardTarget(Agent agent) {
        return (Agent)this.request(agent, Request.Guard);
    }

    @Override
    public Agent requestAttackTarget(Agent agent) {
        return (Agent)this.request(agent, Request.Attack);
    }

    @Override
    public void finish(Agent agent) {
        this.send(agent, Request.Finish);
        this.send(agent, Request.Finish);
    }

    @Override
    public void setGameData(GameData gameData) {
        this.gameData = gameData;
    }

    @Override
    public void dayStart(Agent agent) {
        this.send(agent, Request.DailyInitialize);
    }

    public boolean isWaitForClient() {
        return this.isWaitForClient;
    }

    public void setWaitForClient(boolean isWaitForClient) {
        this.isWaitForClient = isWaitForClient;
    }

    @Override
    public void close() {
        for (Socket socket : this.socketAgentMap.keySet()) {
            try {
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Logger getServerLogger() {
        return this.serverLogger;
    }

    public void setServerLogger(Logger serverLogger) {
        this.serverLogger = serverLogger;
    }
}

