/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.server.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Player;
import org.aiwolf.common.data.Role;
import org.aiwolf.server.GameData;
import org.aiwolf.server.net.GameServer;

public class DirectConnectServer
implements GameServer {
    Map<Agent, Player> agentPlayerMap = new LinkedHashMap<Agent, Player>();
    Map<Agent, Role> requestRoleMap;
    GameData gameData;

    public DirectConnectServer(List<Player> playerList) {
        int idx = 1;
        for (Player player : playerList) {
            this.agentPlayerMap.put(Agent.getAgent((int)idx++), player);
        }
        this.requestRoleMap = new HashMap<Agent, Role>();
    }

    public DirectConnectServer(Map<Player, Role> playerMap) {
        this.requestRoleMap = new HashMap<Agent, Role>();
        int idx = 1;
        for (Player player : playerMap.keySet()) {
            Agent agent = Agent.getAgent((int)idx++);
            this.agentPlayerMap.put(agent, player);
            this.requestRoleMap.put(agent, playerMap.get(player));
        }
    }

    @Override
    public List<Agent> getConnectedAgentList() {
        return new ArrayList<Agent>(this.agentPlayerMap.keySet());
    }

    @Override
    public void setGameData(GameData gameData) {
        this.gameData = gameData;
    }

    @Override
    public void init(Agent agent) {
        this.agentPlayerMap.get(agent).update(this.gameData.getGameInfo(agent));
        this.agentPlayerMap.get(agent).initialize();
    }

    @Override
    public void dayStart(Agent agent) {
        this.agentPlayerMap.get(agent).update(this.gameData.getGameInfo(agent));
        this.agentPlayerMap.get(agent).dayStart();
    }

    @Override
    public String requestName(Agent agent) {
        return this.agentPlayerMap.get(agent).getName();
    }

    @Override
    public Role requestRequestRole(Agent agent) {
        return this.requestRoleMap.get(agent);
    }

    @Override
    public String requestTalk(Agent agent) {
        this.agentPlayerMap.get(agent).update(this.gameData.getGameInfo(agent));
        return this.agentPlayerMap.get(agent).talk();
    }

    @Override
    public String requestWhisper(Agent agent) {
        this.agentPlayerMap.get(agent).update(this.gameData.getGameInfo(agent));
        return this.agentPlayerMap.get(agent).whisper();
    }

    @Override
    public Agent requestVote(Agent agent) {
        this.agentPlayerMap.get(agent).update(this.gameData.getGameInfo(agent));
        return this.agentPlayerMap.get(agent).vote();
    }

    @Override
    public Agent requestDivineTarget(Agent agent) {
        this.agentPlayerMap.get(agent).update(this.gameData.getGameInfo(agent));
        return this.agentPlayerMap.get(agent).divine();
    }

    @Override
    public Agent requestGuardTarget(Agent agent) {
        this.agentPlayerMap.get(agent).update(this.gameData.getGameInfo(agent));
        return this.agentPlayerMap.get(agent).guard();
    }

    @Override
    public Agent requestAttackTarget(Agent agent) {
        this.agentPlayerMap.get(agent).update(this.gameData.getGameInfo(agent));
        return this.agentPlayerMap.get(agent).attack();
    }

    @Override
    public void finish(Agent agent) {
        this.agentPlayerMap.get(agent).update(this.gameData.getFinalGameInfo(agent));
        this.agentPlayerMap.get(agent).finish();
    }

    @Override
    public void close() {
    }
}

