/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Guard;
import org.aiwolf.common.data.Judge;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Species;
import org.aiwolf.common.data.Status;
import org.aiwolf.common.data.Talk;
import org.aiwolf.common.data.Team;
import org.aiwolf.common.data.Vote;
import org.aiwolf.common.net.GameInfo;
import org.aiwolf.common.net.GameInfoToSend;
import org.aiwolf.common.net.JudgeToSend;
import org.aiwolf.common.net.TalkToSend;
import org.aiwolf.common.net.VoteToSend;
import org.aiwolf.server.GameSetting;

public class GameData {
    static final int firstDay = 1;
    int day;
    Map<Agent, Status> agentStatusMap = new LinkedHashMap<Agent, Status>();
    Map<Agent, Role> agentRoleMap = new HashMap<Agent, Role>();
    List<Talk> talkList = new ArrayList<Talk>();
    List<Talk> wisperList = new ArrayList<Talk>();
    List<Vote> voteList = new ArrayList<Vote>();
    List<Vote> attackCandidateList = new ArrayList<Vote>();
    Judge divine;
    Guard guard;
    Agent executed;
    Agent attacked;
    List<Agent> suddendeathList = new ArrayList<Agent>();
    GameData dayBefore;
    int talkIdx;
    int wisperIdx;
    GameSetting gameSetting;

    protected GameData(GameSetting gameSetting) {
        this.gameSetting = gameSetting;
    }

    public GameInfo getGameInfo(Agent agent) {
        return this.getGameInfoToSend(agent).toGameInfo();
    }

    public GameInfo getFinalGameInfo(Agent agent) {
        return this.getFinalGameInfoToSend(agent).toGameInfo();
    }

    public GameInfoToSend getGameInfoToSend(Agent agent) {
        GameData today = this;
        GameInfoToSend gi = new GameInfoToSend();
        int day = today.getDay();
        gi.setAgent(agent.getAgentIdx());
        GameData yesterday = today.getDayBefore();
        if (yesterday != null) {
            Judge divine;
            Agent attacked;
            Agent executed = yesterday.getExecuted();
            if (executed != null) {
                gi.setExecutedAgent(executed.getAgentIdx());
            }
            if ((attacked = yesterday.getAttacked()) != null) {
                gi.setAttackedAgent(attacked.getAgentIdx());
            }
            if (this.gameSetting.isVoteVisible) {
                ArrayList<VoteToSend> voteList = new ArrayList<VoteToSend>();
                for (Vote vote : yesterday.getVoteList()) {
                    voteList.add(new VoteToSend(vote));
                }
                gi.setVoteList(voteList);
            }
            if (today.getRole(agent).equals((Object)Role.medium) && executed != null) {
                Species result = yesterday.getRole(executed).getSpecies();
                gi.setMediumResult(new JudgeToSend(new Judge(day, agent, executed, result)));
            }
            if (today.getRole(agent).equals((Object)Role.seer) && (divine = yesterday.getDivine()) != null && divine.getTarget() != null) {
                Species result = yesterday.getRole(divine.getTarget()).getSpecies();
                gi.setDivineResult(new JudgeToSend(new Judge(day, agent, divine.getTarget(), result)));
            }
            if (today.getRole(agent).equals((Object)Role.werewolf)) {
                ArrayList attackVoteList = new ArrayList();
                for (Vote vote : yesterday.getAttackVoteList()) {
                    attackVoteList.add(new VoteToSend(vote));
                }
                gi.setVoteList((List)attackVoteList);
            }
        }
        ArrayList<TalkToSend> talkList = new ArrayList<TalkToSend>();
        for (Talk talk : today.getTalkList()) {
            talkList.add(new TalkToSend(talk));
        }
        gi.setTalkList(talkList);
        LinkedHashMap<Integer, String> statusMap = new LinkedHashMap<Integer, String>();
        for (Agent a : this.agentStatusMap.keySet()) {
            statusMap.put(a.getAgentIdx(), this.agentStatusMap.get(a).toString());
        }
        gi.setStatusMap(statusMap);
        LinkedHashMap<Integer, String> roleMap = new LinkedHashMap<Integer, String>();
        roleMap.put(agent.getAgentIdx(), this.agentRoleMap.get(agent).toString());
        if (today.getRole(agent).equals((Object)Role.werewolf)) {
            ArrayList<TalkToSend> whisperList = new ArrayList<TalkToSend>();
            for (Talk talk : today.getWhisperList()) {
                whisperList.add(new TalkToSend(talk));
            }
            gi.setWhisperList(whisperList);
            for (Agent target : today.getAgentList()) {
                if (today.getRole(target) != Role.werewolf) continue;
                roleMap.put(target.getAgentIdx(), Role.werewolf.toString());
            }
        }
        if (today.getRole(agent).equals((Object)Role.freemason)) {
            for (Agent target : today.getAgentList()) {
                if (today.getRole(target) != Role.freemason) continue;
                roleMap.put(target.getAgentIdx(), Role.freemason.toString());
            }
        }
        gi.setRoleMap(roleMap);
        gi.setDay(day);
        return gi;
    }

    public GameInfoToSend getFinalGameInfoToSend(Agent agent) {
        GameInfoToSend gi = this.getGameInfoToSend(agent);
        LinkedHashMap<Integer, String> roleMap = new LinkedHashMap<Integer, String>();
        for (Agent a : this.agentRoleMap.keySet()) {
            roleMap.put(a.getAgentIdx(), this.agentRoleMap.get(a).toString());
        }
        gi.setRoleMap(roleMap);
        return gi;
    }

    public void addAgent(Agent agent, Status status, Role role) {
        this.agentRoleMap.put(agent, role);
        this.agentStatusMap.put(agent, status);
    }

    public List<Agent> getAgentList() {
        return new ArrayList<Agent>(this.agentRoleMap.keySet());
    }

    public Status getStatus(Agent agent) {
        return this.agentStatusMap.get(agent);
    }

    public Role getRole(Agent agent) {
        return this.agentRoleMap.get(agent);
    }

    public void addTalk(Agent agent, Talk talk) {
        this.talkList.add(talk);
    }

    public void addWisper(Agent agent, Talk wisper) {
        this.wisperList.add(wisper);
    }

    public void addVote(Vote vote) {
        this.voteList.add(vote);
    }

    public void addDivine(Judge divine) {
        this.divine = divine;
    }

    public void addGuard(Guard guard) {
        this.guard = guard;
    }

    public void addAttack(Vote attack) {
        this.attackCandidateList.add(attack);
    }

    public List<Vote> getVoteList() {
        return this.voteList;
    }

    public void setExecuteTarget(Agent target) {
        this.executed = target;
    }

    public void setAttackedTarget(Agent attacked) {
        this.attacked = attacked;
    }

    public List<Vote> getAttackVoteList() {
        return this.attackCandidateList;
    }

    public Guard getGuard() {
        return this.guard;
    }

    public int getDay() {
        return this.day;
    }

    public List<Talk> getTalkList() {
        return this.talkList;
    }

    public List<Talk> getWhisperList() {
        return this.wisperList;
    }

    public Judge getDivine() {
        return this.divine;
    }

    public Agent getExecuted() {
        return this.executed;
    }

    public Agent getAttacked() {
        return this.attacked;
    }

    public List<Agent> getSuddendeathList() {
        return this.suddendeathList;
    }

    protected GameData nextDay() {
        GameData gameData = new GameData(this.gameSetting);
        gameData.day = this.day + 1;
        gameData.agentStatusMap = new HashMap<Agent, Status>(this.agentStatusMap);
        if (this.executed != null) {
            gameData.agentStatusMap.put(this.executed, Status.dead);
        }
        if (this.attacked != null) {
            gameData.agentStatusMap.put(this.attacked, Status.dead);
        }
        gameData.agentRoleMap = new HashMap<Agent, Role>(this.agentRoleMap);
        gameData.dayBefore = this;
        return gameData;
    }

    public GameData getDayBefore() {
        return this.dayBefore;
    }

    protected List<Agent> getFilteredAgentList(List<Agent> agentList, Species species) {
        ArrayList<Agent> resultList = new ArrayList<Agent>();
        for (Agent agent : agentList) {
            if (this.getRole(agent).getSpecies() != species) continue;
            resultList.add(agent);
        }
        return resultList;
    }

    protected List<Agent> getFilteredAgentList(List<Agent> agentList, Status status) {
        ArrayList<Agent> resultList = new ArrayList<Agent>();
        for (Agent agent : agentList) {
            if (this.getStatus(agent) != status) continue;
            resultList.add(agent);
        }
        return resultList;
    }

    protected List<Agent> getFilteredAgentList(List<Agent> agentList, Role role) {
        ArrayList<Agent> resultList = new ArrayList<Agent>();
        for (Agent agent : agentList) {
            if (this.getRole(agent) != role) continue;
            resultList.add(agent);
        }
        return resultList;
    }

    protected List<Agent> getFilteredAgentList(List<Agent> agentList, Team team) {
        ArrayList<Agent> resultList = new ArrayList<Agent>();
        for (Agent agent : agentList) {
            if (this.getRole(agent).getTeam() != team) continue;
            resultList.add(agent);
        }
        return resultList;
    }

    public int nextTalkIdx() {
        return this.talkIdx++;
    }

    public int nextWhisperIdx() {
        return this.wisperIdx++;
    }
}

