/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Guard;
import org.aiwolf.common.data.Judge;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Species;
import org.aiwolf.common.data.Status;
import org.aiwolf.common.data.Talk;
import org.aiwolf.common.data.Team;
import org.aiwolf.common.data.Vote;
import org.aiwolf.common.net.GameInfo;
import org.aiwolf.common.util.AiWolfLoggerFactory;
import org.aiwolf.common.util.Counter;
import org.aiwolf.server.GameData;
import org.aiwolf.server.GameSetting;
import org.aiwolf.server.IllegalPlayerNumException;
import org.aiwolf.server.net.GameServer;

public class AIWolfGame {
    Random rand = new Random();
    GameSetting gameSetting;
    GameServer gameServer;
    Map<Integer, GameData> gameDataMap;
    GameData gameData;
    File logFile;
    Logger gameLogger;
    Map<Agent, String> agentNameMap;

    public AIWolfGame(GameSetting gameSeting, GameServer gameServer) {
        this.gameSetting = gameSeting;
        this.gameServer = gameServer;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) throws IOException {
        this.logFile = logFile;
        this.gameLogger = AiWolfLoggerFactory.getGameLogger((File)logFile);
    }

    public void setRand(Random rand) {
        this.rand = rand;
    }

    public void init() {
        this.gameDataMap = new TreeMap<Integer, GameData>();
        this.gameData = new GameData(this.gameSetting);
        this.agentNameMap = new HashMap<Agent, String>();
        List<Agent> agentList = this.gameServer.getConnectedAgentList();
        if (agentList.size() != this.gameSetting.getPlayerNum()) {
            throw new IllegalPlayerNumException("Player num is " + this.gameSetting.getPlayerNum() + " but connected agent is " + agentList.size());
        }
        Collections.shuffle(agentList, this.rand);
        HashMap requestRoleMap = new HashMap();
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            requestRoleMap.put(role, new ArrayList());
            ++n2;
        }
        ArrayList<Agent> noRequestAgentList = new ArrayList<Agent>();
        for (Agent agent : agentList) {
            Role requestedRole = this.gameServer.requestRequestRole(agent);
            if (requestedRole != null) {
                ((List)requestRoleMap.get(requestedRole)).add(agent);
                System.out.println(agent + " request " + requestedRole);
                continue;
            }
            noRequestAgentList.add(agent);
            System.out.println(agent + " request no role");
        }
        Role[] roleArray2 = Role.values();
        int n3 = roleArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Role role = roleArray2[n4];
            List requestedAgentList = (List)requestRoleMap.get(role);
            int i = 0;
            while (i < this.gameSetting.getRoleNum(role)) {
                if (requestedAgentList.isEmpty()) {
                    this.gameData.addAgent((Agent)noRequestAgentList.remove(0), Status.alive, role);
                } else {
                    this.gameData.addAgent((Agent)requestedAgentList.remove(0), Status.alive, role);
                }
                ++i;
            }
            ++n4;
        }
        this.gameDataMap.put(this.gameData.getDay(), this.gameData);
        this.gameServer.setGameData(this.gameData);
        for (Agent agent : agentList) {
            this.gameServer.init(agent);
            this.agentNameMap.put(agent, this.gameServer.requestName(agent));
        }
    }

    public void start() {
        this.init();
        while (!this.isGameFinished()) {
            this.log();
            this.day();
            this.night();
        }
        this.log();
        this.finish();
        System.out.println("Winner:" + this.getWinner());
        Iterator<Agent> iterator = this.gameData.getAgentList().iterator();
        if (iterator.hasNext()) {
            Agent agent = iterator.next();
            GameInfo gameInfo = this.gameData.getGameInfo(agent);
        }
    }

    public void finish() {
        for (Agent agent : new TreeSet<Agent>(this.gameData.getAgentList())) {
            this.gameLogger.info(String.format("%d,status,%d,%s,%s,%s", this.gameData.getDay(), agent.getAgentIdx(), this.gameData.getRole(agent), this.gameData.getStatus(agent), this.agentNameMap.get(agent)));
        }
        this.gameLogger.info(String.format("%d,result,%d,%d,%s", this.gameData.getDay(), this.getAliveHumanList().size(), this.getAliveWolfList().size(), this.getWinner()));
        for (Agent agent : this.gameData.getAgentList()) {
            System.out.println("Send finish to " + agent);
            this.gameServer.finish(agent);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public Team getWinner() {
        int humanSide = 0;
        int wolfSide = 0;
        for (Agent agent : this.gameData.getAgentList()) {
            if (this.gameData.getStatus(agent) == Status.dead) continue;
            if (this.gameData.getRole(agent).getSpecies() == Species.Human) {
                ++humanSide;
                continue;
            }
            ++wolfSide;
        }
        if (wolfSide == 0) {
            return Team.villager;
        }
        if (humanSide <= wolfSide) {
            return Team.werewolf;
        }
        return null;
    }

    private void log() {
        GameData yesterday = this.gameData.getDayBefore();
        System.out.println("===========");
        System.out.printf("Day %02d\n", this.gameData.getDay());
        if (yesterday != null) {
            Guard guard;
            Judge divine = yesterday.getDivine();
            System.out.printf("%s executed\n", yesterday.getExecuted());
            if (divine != null) {
                System.out.printf("%s divine %s. Result is %s\n", divine.getAgent(), divine.getTarget(), divine.getResult());
            }
            if ((guard = yesterday.getGuard()) != null) {
                System.out.printf("%s guarded\n", guard);
            }
            System.out.printf("%s attacked\n", yesterday.getAttacked());
        }
        List<Agent> agentList = this.gameData.getAgentList();
        Collections.sort(agentList, new Comparator<Agent>(){

            @Override
            public int compare(Agent o1, Agent o2) {
                return o1.getAgentIdx() - o2.getAgentIdx();
            }
        });
        System.out.println("======");
        for (Agent agent : agentList) {
            System.out.printf("%s\t%s\t%s\t%s", agent, this.agentNameMap.get(agent), this.gameData.getStatus(agent), this.gameData.getRole(agent));
            if (yesterday != null) {
                Guard guard;
                Judge divine;
                if (yesterday.getExecuted() == agent) {
                    System.out.print("\texecuted");
                }
                if (yesterday.getAttacked() == agent) {
                    System.out.print("\tattacked");
                }
                if ((divine = yesterday.getDivine()) != null && divine.getTarget() == agent) {
                    System.out.print("\tdivined");
                }
                if ((guard = yesterday.getGuard()) != null && guard.getTarget() == agent) {
                    System.out.print("\tguarded");
                }
            }
            System.out.println();
        }
        System.out.printf("%d-%d\n", this.getAliveHumanList().size(), this.getAliveWolfList().size());
        if (yesterday != null) {
            for (Talk talk : yesterday.getTalkList()) {
                System.out.println(talk);
            }
        }
        if (yesterday != null) {
            for (Talk whisper : yesterday.getWhisperList()) {
                System.out.println(whisper);
            }
        }
        System.out.println("===========");
    }

    protected void day() {
        this.dayStart();
        this.talk();
        this.vote();
        this.divine();
        this.guard();
        this.attack();
    }

    protected void night() {
        List<Vote> voteList = this.gameData.getVoteList();
        Agent target = this.getVotedAgent(voteList);
        if (this.gameData.getStatus(target) == Status.alive) {
            this.gameData.setExecuteTarget(target);
            this.gameLogger.info(String.format("%d,execute,%d,%s", this.gameData.getDay(), target.getAgentIdx(), this.gameData.getRole(target)));
        }
        if (this.getAliveWolfList().size() != 1 || this.gameData.getRole(this.gameData.getExecuted()) != Role.werewolf) {
            List<Vote> attackCandidateList = this.gameData.getAttackVoteList();
            Agent attacked = this.getAttackVotedAgent(attackCandidateList);
            if (!(this.gameData.getGuard() != null && this.gameData.getGuard().getTarget().equals((Object)attacked) || attacked == null)) {
                this.gameData.setAttackedTarget(attacked);
                this.gameLogger.info(String.format("%d,attack,%d,true", this.gameData.getDay(), attacked.getAgentIdx()));
            } else if (attacked != null) {
                this.gameLogger.info(String.format("%d,attack,%d,false", this.gameData.getDay(), attacked.getAgentIdx()));
            }
        }
        this.gameData = this.gameData.nextDay();
        this.gameDataMap.put(this.gameData.getDay(), this.gameData);
        this.gameServer.setGameData(this.gameData);
    }

    protected Agent getVotedAgent(List<Vote> voteList) {
        Counter counter = new Counter();
        for (Vote vote : voteList) {
            if (this.gameData.getStatus(vote.getTarget()) != Status.alive) continue;
            counter.add((Object)vote.getTarget());
        }
        int max = counter.get(counter.getLargest());
        ArrayList<Agent> candidateList = new ArrayList<Agent>();
        for (Agent agent : counter) {
            if (counter.get((Object)agent) != max) continue;
            candidateList.add(agent);
        }
        if (candidateList.isEmpty()) {
            return null;
        }
        Collections.shuffle(candidateList, this.rand);
        return (Agent)candidateList.get(0);
    }

    protected Agent getAttackVotedAgent(List<Vote> voteList) {
        Counter counter = new Counter();
        for (Vote vote : voteList) {
            if (this.gameData.getStatus(vote.getTarget()) != Status.alive || this.gameData.getRole(vote.getTarget()) == Role.werewolf) continue;
            counter.add((Object)vote.getTarget());
        }
        if (!this.gameSetting.isEnableNoAttack()) {
            for (Agent agent : this.getAliveHumanList()) {
                counter.add((Object)agent);
            }
        }
        int max = counter.get(counter.getLargest());
        ArrayList<Agent> candidateList = new ArrayList<Agent>();
        for (Agent agent : counter) {
            if (counter.get((Object)agent) != max) continue;
            candidateList.add(agent);
        }
        if (candidateList.isEmpty()) {
            return null;
        }
        Collections.shuffle(candidateList, this.rand);
        return (Agent)candidateList.get(0);
    }

    protected void dayStart() {
        for (Agent agent : new TreeSet<Agent>(this.gameData.getAgentList())) {
            this.gameLogger.info(String.format("%d,status,%d,%s,%s,%s", this.gameData.getDay(), agent.getAgentIdx(), this.gameData.getRole(agent), this.gameData.getStatus(agent), this.agentNameMap.get(agent)));
        }
        for (Agent agent : this.getAliveAgentList()) {
            this.gameServer.dayStart(agent);
        }
    }

    protected void talk() {
        int i = 0;
        while (i < this.gameSetting.getMaxTalk()) {
            boolean continueTalk = false;
            List<Agent> alivelist = this.getAliveAgentList();
            Collections.shuffle(alivelist);
            for (Agent agent : alivelist) {
                String talkContent = this.gameServer.requestTalk(agent);
                if (talkContent == null || talkContent.isEmpty()) continue;
                Talk sentence = new Talk(this.gameData.nextTalkIdx(), this.gameData.getDay(), agent, talkContent);
                this.gameData.addTalk(agent, sentence);
                if (!talkContent.equals("Over")) {
                    continueTalk = true;
                }
                this.gameLogger.info(String.format("%d,talk,%d,%d,%s", this.gameData.getDay(), sentence.getIdx(), agent.getAgentIdx(), sentence.getContent()));
            }
            this.whisper();
            if (!continueTalk) break;
            ++i;
        }
    }

    protected void whisper() {
        int j = 0;
        while (j < this.gameSetting.getMaxTalk()) {
            List<Agent> alivelist = this.getAliveAgentList();
            boolean continueWhisper = false;
            Collections.shuffle(alivelist);
            for (Agent agent : alivelist) {
                String whisperContent;
                if (this.gameData.getRole(agent) != Role.werewolf || (whisperContent = this.gameServer.requestWhisper(agent)).isEmpty()) continue;
                Talk whisper = new Talk(this.gameData.nextWhisperIdx(), this.gameData.getDay(), agent, whisperContent);
                this.gameData.addWisper(agent, whisper);
                if (!whisperContent.equals("Over")) {
                    continueWhisper = true;
                }
                this.gameLogger.info(String.format("%d,whisper,%d,%d,%s", this.gameData.getDay(), whisper.getIdx(), agent.getAgentIdx(), whisper.getContent()));
            }
            if (!continueWhisper) break;
            ++j;
        }
    }

    protected void vote() {
        for (Agent agent : this.getAliveAgentList()) {
            Agent target = this.gameServer.requestVote(agent);
            Vote vote = new Vote(this.gameData.getDay(), agent, target);
            this.gameData.addVote(vote);
            this.gameLogger.info(String.format("%d,vote,%d,%d", this.gameData.getDay(), vote.getAgent().getAgentIdx(), vote.getTarget().getAgentIdx()));
        }
    }

    protected void divine() {
        for (Agent agent : this.getAliveAgentList()) {
            if (this.gameData.getRole(agent) != Role.seer) continue;
            Agent target = this.gameServer.requestDivineTarget(agent);
            Judge divine = new Judge(this.gameData.getDay(), agent, target, this.gameData.getRole(target).getSpecies());
            this.gameData.addDivine(divine);
            this.gameLogger.info(String.format("%d,divine,%d,%d,%s", this.gameData.getDay(), divine.getAgent().getAgentIdx(), divine.getTarget().getAgentIdx(), divine.getResult()));
        }
    }

    protected void guard() {
        for (Agent agent : this.getAliveAgentList()) {
            if (this.gameData.getRole(agent) != Role.bodyguard) continue;
            Agent target = this.gameServer.requestGuardTarget(agent);
            Guard guard = new Guard(this.gameData.getDay(), agent, target);
            this.gameData.addGuard(guard);
            this.gameLogger.info(String.format("%d,guard,%d,%d,%s", this.gameData.getDay(), guard.getAgent().getAgentIdx(), guard.getTarget().getAgentIdx(), this.gameData.getRole(guard.getTarget())));
        }
    }

    protected void attack() {
        for (Agent agent : this.getAliveAgentList()) {
            if (this.gameData.getRole(agent) != Role.werewolf) continue;
            Agent target = this.gameServer.requestAttackTarget(agent);
            Vote attackVote = new Vote(this.gameData.getDay(), agent, target);
            this.gameData.addAttack(attackVote);
            this.gameLogger.info(String.format("%d,attackVote,%d,%d", this.gameData.getDay(), attackVote.getAgent().getAgentIdx(), attackVote.getTarget().getAgentIdx()));
        }
    }

    protected List<Agent> getAliveAgentList() {
        ArrayList<Agent> agentList = new ArrayList<Agent>();
        for (Agent agent : this.gameData.getAgentList()) {
            if (this.gameData.getStatus(agent) != Status.alive) continue;
            agentList.add(agent);
        }
        return agentList;
    }

    protected List<Agent> getAliveHumanList() {
        return this.gameData.getFilteredAgentList(this.getAliveAgentList(), Species.Human);
    }

    protected List<Agent> getAliveWolfList() {
        return this.gameData.getFilteredAgentList(this.getAliveAgentList(), Species.Werewolf);
    }

    public boolean isGameFinished() {
        Team winner = this.getWinner();
        return winner != null;
    }

    public GameData getGameData() {
        return this.gameData;
    }
}

