/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.aiwolf.client.base.smpl.SamplePlayer;
import org.aiwolf.common.data.Player;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.util.CalendarTools;
import org.aiwolf.common.util.Pair;
import org.aiwolf.server.AIWolfGame;
import org.aiwolf.server.GameSetting;
import org.aiwolf.server.net.DirectConnectServer;

public class RoleRequestStarter {
    private static final String description = "\u3053\u306e\u30af\u30e9\u30b9\u3092\u5229\u7528\u3057\u3066\uff0c\u81ea\u4f5cPlayer\u3054\u3068\u306b\u5f79\u8077\u3092\u6c7a\u3081\u3066\u30b2\u30fc\u30e0\u3092\u30b9\u30bf\u30fc\u30c8\u3067\u304d\u307e\u3059\uff0e\nUsage:" + RoleRequestStarter.class + " -n agentNum -c playerClass role [-c playerClass role] [-d defaultPlayer]\n" + "-n\t\u30b2\u30fc\u30e0\u306b\u53c2\u52a0\u3059\u308b\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u6570\u3092\u6c7a\u5b9a\u3057\u307e\u3059\uff0e\n" + "-c '\u30d7\u30ec\u30a4\u30e4\u30fc\u30af\u30e9\u30b9'\u3000'\u8a2d\u5b9a\u3057\u305f\u3044\u5f79\u8077'\u3000\u3092\u8a2d\u5b9a\u3057\u307e\u3059\uff0e\n" + "-c '\u30d7\u30ec\u30a4\u30e4\u30fc\u30af\u30e9\u30b9'\u3000\u3067\uff0c\u5f79\u8077\u3092\u6307\u5b9a\u305b\u305a\u306b\u5229\u7528\u3059\u308bPlayer\u3092\u6307\u5b9a\u3057\u307e\u3059\uff0e\n" + "-d \u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30d7\u30ec\u30a4\u30e4\u30fc\u30af\u30e9\u30b9\u3092\u6307\u5b9a\u3057\u307e\u3059\uff0e\u6307\u5b9a\u3057\u306a\u3051\u308c\u3070SamplePlayer\u304c\u4f7f\u308f\u308c\u307e\u3059\uff0e\n" + "-l \u30ed\u30b0\u3092\u4fdd\u5b58\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u6307\u5b9a\uff0e\u30c7\u30d5\u30a9\u30eb\u30c8\u306f./log/\n" + "\u4f8b\u3048\u3070\uff0c\u81ea\u4f5c\u306eorg.aiwolf.MyPlayer\u3092bodyguard\u3068\u3057\u306612\u4f53\u306e\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u3067\u4eba\u72fc\u3092\u5b9f\u884c\u3057\u305f\u3051\u308c\u3070\n" + RoleRequestStarter.class + " -n 12 -c org.aiwolf.MyPlayer bodyguard\n" + "\u3068\u3057\u3066\u304f\u3060\u3055\u3044\uff0e\n";

    public static void main(String[] args) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        ArrayList<Pair> playerRoleList = new ArrayList<Pair>();
        String defaultClsName = SamplePlayer.class.getName();
        int playerNum = -1;
        String logDir = "./log/";
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c")) {
                    String clsName = args[++i];
                    ++i;
                    try {
                        if (i > args.length - 1 || args[i].startsWith("-")) {
                            --i;
                            playerRoleList.add(new Pair((Object)clsName, null));
                        }
                        Role role = Role.valueOf((String)args[i]);
                        playerRoleList.add(new Pair((Object)clsName, (Object)role));
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("No such role as " + args[i]);
                        return;
                    }
                } else if (args[i].equals("-n")) {
                    playerNum = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-d")) {
                    defaultClsName = args[++i];
                } else if (args[i].equals("-l")) {
                    logDir = args[++i];
                } else if (args[i].equals("-h")) {
                    System.out.println(description);
                    System.out.println("\u5229\u7528\u53ef\u80fd\u306a\u5f79\u8077");
                    Role[] roleArray = Role.values();
                    int n = roleArray.length;
                    int e = 0;
                    while (e < n) {
                        Role role = roleArray[e];
                        System.out.println(role);
                        ++e;
                    }
                }
            }
            ++i;
        }
        if (playerNum < 0) {
            System.err.println("Usage:" + RoleRequestStarter.class + " -n agentNum -c playerClass role [-c playerClass role...] [-d defaultPlayer] [-l logDir]");
            return;
        }
        HashMap<Player, Role> playerMap = new HashMap<Player, Role>();
        for (Pair pair : playerRoleList) {
            playerMap.put((Player)Class.forName((String)pair.getKey()).newInstance(), (Role)pair.getValue());
        }
        while (playerMap.size() < playerNum) {
            playerMap.put((Player)Class.forName(defaultClsName).newInstance(), null);
        }
        String timeString = CalendarTools.toDateTime((long)System.currentTimeMillis()).replaceAll("[\\s-/:]", "");
        File logFile = new File(String.format("%s/aiwolfGame%s.log", logDir, timeString));
        DirectConnectServer gameServer = new DirectConnectServer(playerMap);
        GameSetting gameSetting = GameSetting.getDefaultGame(playerNum);
        AIWolfGame game = new AIWolfGame(gameSetting, gameServer);
        game.setLogFile(logFile);
        game.setRand(new Random());
        game.start();
    }
}

