/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.aiwolf.common.data.Player;
import org.aiwolf.common.util.CalendarTools;
import org.aiwolf.common.util.Counter;
import org.aiwolf.server.AIWolfGame;
import org.aiwolf.server.GameSetting;
import org.aiwolf.server.net.DirectConnectServer;

public class DirectStarter {
    public static void main(String[] args) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        Counter clsCountMap = new Counter();
        String logDir = "./log/";
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c")) {
                    String clsName = args[++i];
                    int num = Integer.parseInt(args[++i]);
                    clsCountMap.put((Object)clsName, Integer.valueOf(num));
                } else if (args[i].equals("-l")) {
                    logDir = args[++i];
                }
            }
            ++i;
        }
        if (clsCountMap.isEmpty()) {
            System.err.println("Usage:" + ClientStarter.class + " -c clientClass num [-c clientClass num ...] [-l logDir]");
            return;
        }
        int playerNum = clsCountMap.getTotalCount();
        ArrayList<Player> playerList = new ArrayList<Player>();
        for (String clsName : clsCountMap) {
            int num = clsCountMap.get((Object)clsName);
            int i2 = 0;
            while (i2 < num) {
                playerList.add((Player)Class.forName(clsName).newInstance());
                ++i2;
            }
        }
        String timeString = CalendarTools.toDateTime((long)System.currentTimeMillis()).replaceAll("[\\s-/:]", "");
        File logFile = new File(String.format("%s/aiwolfGame%s.log", logDir, timeString));
        DirectConnectServer gameServer = new DirectConnectServer(playerList);
        GameSetting gameSetting = GameSetting.getDefaultGame(playerNum);
        AIWolfGame game = new AIWolfGame(gameSetting, gameServer);
        game.setLogFile(logFile);
        game.setRand(new Random());
        game.start();
    }
}

