/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Sorter<V, S>
implements Map<V, S>,
Serializable {
    protected final Map<V, S> itemMap;
    protected Comparator<S> scoreComparator;

    public Sorter() {
        this.itemMap = new LinkedHashMap<V, S>();
    }

    public Sorter(Comparator<S> comparator) {
        this();
        this.scoreComparator = comparator;
    }

    public Sorter(Map<? extends V, ? extends S> map) {
        this.itemMap = new LinkedHashMap<S, S>(map);
    }

    public void set(V v, S s) {
        this.itemMap.put(v, s);
    }

    @Override
    public S get(Object v) {
        return this.itemMap.get(v);
    }

    public List<V> getSortedList() {
        ArrayList<V> list = new ArrayList<V>(this.itemMap.keySet());
        Collections.sort(list, new ItemComparator());
        return list;
    }

    public List<V> getReverseList() {
        ArrayList<V> list = new ArrayList<V>(this.itemMap.keySet());
        Collections.sort(list, new ItemComparator());
        Collections.reverse(list);
        return list;
    }

    @Override
    public void clear() {
        this.itemMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.itemMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.itemMap.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.itemMap.isEmpty();
    }

    @Override
    public Set<V> keySet() {
        return new LinkedHashSet<V>(this.getSortedList());
    }

    @Override
    public S remove(Object key) {
        return this.itemMap.remove(key);
    }

    @Override
    public int size() {
        return this.itemMap.size();
    }

    @Override
    public Collection<S> values() {
        return this.itemMap.values();
    }

    @Override
    public S put(V key, S value) {
        return this.itemMap.put(key, value);
    }

    @Override
    public void putAll(Map<? extends V, ? extends S> m) {
        this.itemMap.putAll(m);
    }

    @Override
    public Set<Map.Entry<V, S>> entrySet() {
        return this.itemMap.entrySet();
    }

    public V getFirstKey() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getSortedList().get(0);
    }

    public V getLastKey() {
        if (this.isEmpty()) {
            return null;
        }
        List<V> list = this.getSortedList();
        return list.get(list.size() - 1);
    }

    public Sorter<V, S> largerThan(S s) {
        Sorter<V, S> sorter = new Sorter<V, S>();
        for (V v : this.keySet()) {
            if (this.compare(this.get(v), s) <= 0) continue;
            sorter.put(v, this.get(v));
        }
        return sorter;
    }

    public Sorter<V, S> smallerThan(S s) {
        Sorter<V, S> sorter = new Sorter<V, S>();
        for (V v : this.keySet()) {
            if (this.compare(this.get(v), s) >= 0) continue;
            sorter.put(v, this.get(v));
        }
        return sorter;
    }

    public Sorter<V, S> largerEqual(S s) {
        Sorter<V, S> sorter = new Sorter<V, S>();
        for (V v : this.keySet()) {
            if (this.compare(this.get(v), s) < 0) continue;
            sorter.put(v, this.get(v));
        }
        return sorter;
    }

    public Sorter<V, S> smallerEqual(S s) {
        Sorter<V, S> sorter = new Sorter<V, S>();
        for (V v : this.keySet()) {
            if (this.compare(this.get(v), s) > 0) continue;
            sorter.put(v, this.get(v));
        }
        return sorter;
    }

    private int compare(S s1, S s2) {
        if (this.scoreComparator != null) {
            return this.scoreComparator.compare(s1, s2);
        }
        if (s1 instanceof Comparable) {
            return ((Comparable)s1).compareTo(s2);
        }
        return 0;
    }

    final class ItemComparator
    implements Comparator<V> {
        ItemComparator() {
        }

        @Override
        public int compare(V v1, V v2) {
            Object s1 = Sorter.this.itemMap.get(v1);
            Object s2 = Sorter.this.itemMap.get(v2);
            if (Sorter.this.scoreComparator != null) {
                return Sorter.this.scoreComparator.compare(s1, s2);
            }
            if (s1 instanceof Comparable) {
                return ((Comparable)s1).compareTo(s2);
            }
            return 0;
        }
    }
}

