/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.common.util;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.aiwolf.common.util.CalendarTools;

public class ServerLogFormat
extends Formatter {
    boolean isDetail;

    public ServerLogFormat(boolean isDetail) {
        this.isDetail = isDetail;
    }

    public ServerLogFormat() {
        this(true);
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer buf = new StringBuffer();
        if (this.isDetail) {
            buf.append(record.getLevel());
            buf.append(" ");
            buf.append(CalendarTools.toDateTime(record.getMillis()));
            buf.append("@");
            buf.append(String.valueOf(record.getSourceClassName()) + "#" + record.getSourceMethodName());
        }
        buf.append(record.getLoggerName());
        buf.append(":");
        buf.append(record.getMessage());
        buf.append("\n");
        return buf.toString();
    }
}

