/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.aiwolf.common.util.Sorter;

public class Counter<V>
implements Iterable<V>,
Map<V, Integer> {
    Sorter<V, Integer> sorter;

    public Counter() {
        this.sorter = new Sorter();
    }

    public int getTotalCount() {
        int total = 0;
        for (int v : this.sorter.values()) {
            total += v;
        }
        return total;
    }

    public List<V> getSortedList() {
        return this.sorter.getSortedList();
    }

    public List<V> getReverseList() {
        return this.sorter.getReverseList();
    }

    public Counter<V> getOver(int min) {
        Counter<V> c = new Counter<V>();
        for (V v : this.getReverseList()) {
            if (this.get(v) < min) continue;
            c.put(v, this.get(v));
        }
        return c;
    }

    public Counter<V> getUnder(int max) {
        Counter<V> c = new Counter<V>();
        for (V v : this.getSortedList()) {
            if (this.get(v) > max) continue;
            c.put(v, this.get(v));
        }
        return c;
    }

    public Counter(Map<? extends V, Integer> map) {
        this.sorter = new Sorter<V, Integer>(map);
    }

    public void add(V v, int num) {
        if (this.sorter.containsKey(v)) {
            this.sorter.put(v, this.sorter.get(v) + num);
        } else {
            this.sorter.put(v, num);
        }
    }

    public void add(V v) {
        this.add(v, 1);
    }

    public void increment(V v) {
        this.add(v, 1);
    }

    @Override
    public Integer get(Object v) {
        if (this.sorter.containsKey(v)) {
            return this.sorter.get(v);
        }
        return 0;
    }

    public V getLargest() {
        if (this.sorter.isEmpty()) {
            return null;
        }
        return this.sorter.getReverseList().get(0);
    }

    public V getSmallest() {
        if (this.sorter.isEmpty()) {
            return null;
        }
        return this.sorter.getSortedList().get(0);
    }

    @Override
    public void clear() {
        this.sorter.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sorter.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.sorter.isEmpty();
    }

    @Override
    public Set<V> keySet() {
        return this.sorter.keySet();
    }

    @Override
    public Integer remove(Object key) {
        return this.sorter.remove(key);
    }

    @Override
    public int size() {
        return this.sorter.size();
    }

    @Override
    public Integer put(V key, Integer value) {
        return this.sorter.put(key, value);
    }

    @Override
    public void putAll(Map<? extends V, ? extends Integer> m) {
        this.sorter.putAll((Map<? extends V, Integer>)m);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sorter.containsValue(value);
    }

    @Override
    public Collection<Integer> values() {
        return this.sorter.values();
    }

    @Override
    public Set<Map.Entry<V, Integer>> entrySet() {
        return this.sorter.entrySet();
    }

    @Override
    public Iterator<V> iterator() {
        return this.sorter.getSortedList().iterator();
    }

    public Iterator<V> reverseIterator() {
        return this.sorter.getReverseList().iterator();
    }

    public Map<Integer, Integer> toHistogram() {
        Counter<Integer> counter = new Counter<Integer>();
        for (int val : this.values()) {
            counter.add(val, 1);
        }
        return new TreeMap<Integer, Integer>(counter);
    }

    public Counter<V> addAll(Counter<V> actionCounter) {
        for (V v : actionCounter.keySet()) {
            this.add(v, actionCounter.get(v));
        }
        return this;
    }
}

