/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.aiwolf.common.util.GameLogFormat;
import org.aiwolf.common.util.ServerLogFormat;

public class AiWolfLoggerFactory {
    protected static final String LOGGING_PROPERTIES = "javalog.properties";

    public static Logger getSimpleLogger(String name) {
        Logger logger = Logger.getLogger(name);
        InputStream inStream = AiWolfLoggerFactory.class.getClassLoader().getResourceAsStream(LOGGING_PROPERTIES);
        if (inStream == null) {
            logger.info("\u30ed\u30b0\u8a2d\u5b9a: javalog.properties \u306f\u30af\u30e9\u30b9\u30d1\u30b9\u4e0a\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        } else {
            try {
                try {
                    LogManager.getLogManager().readConfiguration(inStream);
                    logger.config("\u30ed\u30b0\u8a2d\u5b9a: LogManager\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002");
                }
                catch (IOException e) {
                    logger.warning("\u30ed\u30b0\u8a2d\u5b9a: LogManager\u8a2d\u5b9a\u306e\u969b\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.toString());
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.warning("\u30ed\u30b0\u8a2d\u5b9a: \u30ed\u30b0\u8a2d\u5b9a\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u30b9\u30c8\u30ea\u30fc\u30e0\u30af\u30ed\u30fc\u30ba\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e2.toString());
                    }
                }
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException e) {
                    logger.warning("\u30ed\u30b0\u8a2d\u5b9a: \u30ed\u30b0\u8a2d\u5b9a\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u30b9\u30c8\u30ea\u30fc\u30e0\u30af\u30ed\u30fc\u30ba\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.toString());
                }
            }
        }
        return logger;
    }

    public static Logger getServerLogger(String name, File outputFile) throws IOException {
        Logger logger = Logger.getLogger(name);
        FileOutputStream out = new FileOutputStream(outputFile);
        StreamHandler handler = new StreamHandler(out, new ServerLogFormat(true));
        logger.addHandler(handler);
        return logger;
    }

    public static Logger getGameLogger(File outputFile) throws IOException {
        Logger logger = AiWolfLoggerFactory.getSimpleLogger("Game");
        outputFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(outputFile);
        StreamHandler handler = new StreamHandler(out, new GameLogFormat());
        logger.addHandler(handler);
        logger.setLevel(Level.ALL);
        return logger;
    }
}

