/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.common.net;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.aiwolf.common.AIWolfRuntimeException;
import org.aiwolf.common.data.Player;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.net.DataConverter;
import org.aiwolf.common.net.GameClient;
import org.aiwolf.common.net.GameInfo;
import org.aiwolf.common.net.Packet;

public class TcpipClient
implements Runnable,
GameClient {
    String host;
    int port;
    Socket socket;
    Player player;
    Role requestRole;
    private boolean isRunning;

    public TcpipClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public boolean connect(Player player) {
        this.player = player;
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.host, this.port));
            Thread th = new Thread(this);
            th.start();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void run() {
        try {
            try {
                String line;
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
                BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.isRunning = true;
                while ((line = br.readLine()) != null && this.isRunning) {
                    Packet packet = DataConverter.getInstance().toPacket(line);
                    Object obj = this.recieve(packet);
                    if (!packet.getRequest().hasReturn()) continue;
                    if (obj instanceof String) {
                        bw.append(obj + "\n");
                    } else {
                        bw.append(String.valueOf(DataConverter.getInstance().convert(obj)) + "\n");
                    }
                    bw.flush();
                }
                System.out.println("Close connectoin of " + this.player);
                br.close();
                bw.close();
                this.socket.close();
            }
            catch (IOException e) {
                throw new AIWolfRuntimeException(e);
            }
        }
        finally {
            this.isRunning = false;
        }
    }

    @Override
    public Object recieve(Packet packet) {
        GameInfo gameInfo = packet.getGameInfo().toGameInfo();
        this.player.update(gameInfo);
        Object returnObject = null;
        switch (packet.getRequest()) {
            case Attack: {
                returnObject = this.player.attack();
                break;
            }
            case DailyInitialize: {
                this.player.dayStart();
                break;
            }
            case Initialize: {
                this.player.initialize();
                break;
            }
            case Name: {
                returnObject = this.player.getName();
                break;
            }
            case Role: {
                if (this.requestRole != null) {
                    returnObject = this.requestRole.toString();
                    break;
                }
                returnObject = "none";
                break;
            }
            case Talk: {
                returnObject = this.player.talk();
                break;
            }
            case Whisper: {
                returnObject = this.player.whisper();
                break;
            }
            case Divine: {
                returnObject = this.player.divine();
                break;
            }
            case Guard: {
                returnObject = this.player.guard();
                break;
            }
            case Vote: {
                returnObject = this.player.vote();
                break;
            }
            case Finish: {
                this.finish();
            }
        }
        return returnObject;
    }

    protected void finish() {
        this.isRunning = false;
        this.player.finish();
    }
}

