/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.common.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Status;
import org.aiwolf.common.data.Talk;
import org.aiwolf.common.data.Vote;
import org.aiwolf.common.net.GameInfo;
import org.aiwolf.common.net.JudgeToSend;
import org.aiwolf.common.net.TalkToSend;
import org.aiwolf.common.net.VoteToSend;

public class GameInfoToSend {
    int day;
    int agent;
    JudgeToSend mediumResult;
    JudgeToSend divineResult;
    int executedAgent = -1;
    int attackedAgent = -1;
    List<VoteToSend> voteList = new ArrayList<VoteToSend>();
    List<VoteToSend> attackVoteList = new ArrayList<VoteToSend>();
    List<TalkToSend> talkList;
    List<TalkToSend> whisperList;
    LinkedHashMap<Integer, String> statusMap = new LinkedHashMap();
    LinkedHashMap<Integer, String> roleMap = new LinkedHashMap();

    public GameInfoToSend() {
        this.talkList = new ArrayList<TalkToSend>();
        this.whisperList = new ArrayList<TalkToSend>();
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getAgent() {
        return this.agent;
    }

    public void setAgent(int agent) {
        this.agent = agent;
    }

    public JudgeToSend getMediumResult() {
        return this.mediumResult;
    }

    public void setMediumResult(JudgeToSend mediumResult) {
        this.mediumResult = mediumResult;
    }

    public JudgeToSend getDivineResult() {
        return this.divineResult;
    }

    public void setDivineResult(JudgeToSend divineResult) {
        this.divineResult = divineResult;
    }

    public int getExecutedAgent() {
        return this.executedAgent;
    }

    public void setExecutedAgent(int executedAgent) {
        this.executedAgent = executedAgent;
    }

    public int getAttackedAgent() {
        return this.attackedAgent;
    }

    public void setAttackedAgent(int attackedAgent) {
        this.attackedAgent = attackedAgent;
    }

    public List<VoteToSend> getVoteList() {
        return this.voteList;
    }

    public void setVoteList(List<VoteToSend> voteList) {
        this.voteList = voteList;
    }

    public List<VoteToSend> getAttackVoteList() {
        return this.attackVoteList;
    }

    public void setAttackVoteList(List<VoteToSend> attackVoteList) {
        this.attackVoteList = attackVoteList;
    }

    public List<TalkToSend> getTalkList() {
        return this.talkList;
    }

    public void setTalkList(List<TalkToSend> talkList) {
        this.talkList = talkList;
    }

    public List<TalkToSend> getWhisperList() {
        return this.whisperList;
    }

    public void setWhisperList(List<TalkToSend> whisperList) {
        this.whisperList = whisperList;
    }

    public Map<Integer, String> getStatusMap() {
        return this.statusMap;
    }

    public void setStatusMap(LinkedHashMap<Integer, String> statusMap) {
        this.statusMap = statusMap;
    }

    public Map<Integer, String> getRoleMap() {
        return this.roleMap;
    }

    public void setRoleMap(LinkedHashMap<Integer, String> roleMap) {
        this.roleMap = roleMap;
    }

    public GameInfo toGameInfo() {
        GameInfo gi = new GameInfo();
        gi.day = this.getDay();
        gi.agent = Agent.getAgent(this.getAgent());
        if (this.getMediumResult() != null) {
            gi.mediumResult = this.getMediumResult().toJudge();
        }
        if (this.getDivineResult() != null) {
            gi.divineResult = this.getDivineResult().toJudge();
        }
        gi.executedAgent = Agent.getAgent(this.getExecutedAgent());
        gi.attackedAgent = Agent.getAgent(this.getAttackedAgent());
        gi.voteList = new ArrayList<Vote>();
        for (VoteToSend vote : this.getVoteList()) {
            gi.voteList.add(vote.toVote());
        }
        gi.attackVoteList = new ArrayList<Vote>();
        for (VoteToSend vote : this.getAttackVoteList()) {
            gi.attackVoteList.add(vote.toVote());
        }
        gi.talkList = new ArrayList<Talk>();
        for (TalkToSend talk : this.getTalkList()) {
            gi.talkList.add(talk.toTalk());
        }
        gi.whisperList = new ArrayList<Talk>();
        for (TalkToSend whisper : this.getWhisperList()) {
            gi.whisperList.add(whisper.toTalk());
        }
        gi.statusMap = new HashMap<Agent, Status>();
        Iterator<Object> iterator = this.getStatusMap().keySet().iterator();
        while (iterator.hasNext()) {
            int agent = (Integer)iterator.next();
            gi.statusMap.put(Agent.getAgent(agent), Status.valueOf(this.getStatusMap().get(agent)));
        }
        gi.roleMap = new HashMap<Agent, Role>();
        iterator = this.getRoleMap().keySet().iterator();
        while (iterator.hasNext()) {
            int agent = (Integer)iterator.next();
            gi.roleMap.put(Agent.getAgent(agent), Role.valueOf(this.getRoleMap().get(agent)));
        }
        return gi;
    }
}

