/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.common.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Judge;
import org.aiwolf.common.data.Role;
import org.aiwolf.common.data.Status;
import org.aiwolf.common.data.Talk;
import org.aiwolf.common.data.Vote;

public class GameInfo {
    int day;
    Agent agent;
    Judge mediumResult;
    Judge divineResult;
    Agent executedAgent;
    Agent attackedAgent;
    List<Vote> voteList = new ArrayList<Vote>();
    List<Vote> attackVoteList = new ArrayList<Vote>();
    List<Talk> talkList = new ArrayList<Talk>();
    List<Talk> whisperList = new ArrayList<Talk>();
    Map<Agent, Status> statusMap = new HashMap<Agent, Status>();
    Map<Agent, Role> roleMap = new HashMap<Agent, Role>();

    public int getDay() {
        return this.day;
    }

    public Role getRole() {
        return this.roleMap.get(this.getAgent());
    }

    public Agent getAgent() {
        return this.agent;
    }

    public List<Agent> getAgentList() {
        return new ArrayList<Agent>(this.statusMap.keySet());
    }

    public Judge getMediumResult() {
        return this.mediumResult;
    }

    public Judge getDivineResult() {
        return this.divineResult;
    }

    public Agent getExecutedAgent() {
        return this.executedAgent;
    }

    public Agent getAttackedAgent() {
        return this.attackedAgent;
    }

    public List<Vote> getVoteList() {
        return this.voteList;
    }

    public List<Vote> getAttackVoteList() {
        return this.attackVoteList;
    }

    public List<Talk> getTalkList() {
        return this.talkList;
    }

    public List<Talk> getWhisperList() {
        return this.whisperList;
    }

    public List<Agent> getHumanList() {
        ArrayList<Agent> humanList = new ArrayList<Agent>(this.getAgentList());
        humanList.removeAll(this.getWolfList());
        return humanList;
    }

    public List<Agent> getWolfList() {
        ArrayList<Agent> wolfList = new ArrayList<Agent>();
        for (Agent agent : this.roleMap.keySet()) {
            if (this.roleMap.get(agent) != Role.werewolf) continue;
            wolfList.add(agent);
        }
        return wolfList;
    }

    public List<Agent> getAliveAgentList() {
        ArrayList<Agent> aliveAgentList = new ArrayList<Agent>();
        if (this.getAgentList() != null) {
            for (Agent target : this.getAgentList()) {
                if (this.statusMap.get(target) != Status.alive) continue;
                aliveAgentList.add(target);
            }
        }
        return aliveAgentList;
    }

    public Map<Agent, Status> getStatusMap() {
        return this.statusMap;
    }

    public Map<Agent, Role> getRoleMap() {
        return this.roleMap;
    }
}

