/*
 * Decompiled with CFR 0.152.
 */
package org.aiwolf.common.net;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.arnx.jsonic.JSON;
import org.aiwolf.common.data.Agent;
import org.aiwolf.common.data.Request;
import org.aiwolf.common.net.GameInfoToSend;
import org.aiwolf.common.net.Packet;

public class DataConverter {
    private static DataConverter converter;

    public static DataConverter getInstance() {
        if (converter == null) {
            converter = new DataConverter();
        }
        return converter;
    }

    private DataConverter() {
    }

    public String convert(Object obj) {
        return JSON.encode((Object)obj);
    }

    public Packet toPacket(String line) {
        LinkedHashMap map = (LinkedHashMap)JSON.decode((String)line);
        Request request = Request.valueOf((String)map.get("request"));
        GameInfoToSend gameInfoToSend = (GameInfoToSend)JSON.decode((String)JSON.encode(map.get("gameInfo")), GameInfoToSend.class);
        return new Packet(request, gameInfoToSend);
    }

    public Agent toAgent(Object obj) {
        Matcher m;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String && (m = Pattern.compile("\\{\"agentIdx\":(\\d+)\\}").matcher((String)obj)).find()) {
            return Agent.getAgent(Integer.parseInt(m.group(1)));
        }
        if (obj instanceof Agent) {
            return (Agent)obj;
        }
        if (obj instanceof Map) {
            return Agent.getAgent(((BigDecimal)((Map)obj).get("agentIdx")).intValue());
        }
        throw new RuntimeException("Can not convert to agent " + obj.getClass() + "\t" + obj);
    }
}

